uniform sampler2D texTo;
uniform sampler2D texFrom;
uniform sampler2D texNoise;

uniform float crossfader;
uniform float randomSeed;
uniform float levelFrom;
uniform float levelTo;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
  vec4 color = gl_Color;

  vec2 center = vec2(0.5,0.5);
  vec2 toUV = uv - center;
  float distanceFromCenter = length(toUV);
  vec2 normToUV = toUV / distanceFromCenter;
  float angle = (atan(normToUV.x,normToUV.y) + 3.141592) / (2.0 * 3.141592);
  float offset1 = texture2D(texNoise, vec2(angle, fract(crossfader/3.0 + distanceFromCenter/5.0 + randomSeed))).x * 2.0 - 1.0;
  float offset2 = offset1 * 2.0 * min(0.3, (1.0-crossfader)) * distanceFromCenter;
  offset1 = offset1 * 2.0 * min(0.3, crossfader) * distanceFromCenter;
    
	vec4 color1 = texture2D(texFrom, fract(center + normToUV * (distanceFromCenter + offset1)));
  color1.a=levelFrom;
	vec4 color2 = texture2D(texTo, fract(center + normToUV * (distanceFromCenter + offset2)));
  color2.a=levelTo;

	gl_FragColor = mix(color1, color2, crossfader);
}